<?php
if ( ! session_id() ) @ session_start();

if (empty($_GET)){
    die('sin permiso de consulta...');
}

include_once('../home.php');
require_once('../assets/dbManager.php');

dbManager::setQueryLogging(false);
dbManager::configFile('../assets/dbconfig.php');

extract($_GET);

$fil = array();

$conn_string = "host=".IPS." port=".DBPORT." dbname=".DBN." user=".DBUSER." password=".DBPASS."";
$dbconn = pg_connect($conn_string);

if (!$dbconn) {
    die('Sin conexión de base de datos...');
}
$sql = 'UPDATE estacion SET nu_lts_91 = (nu_lts_91 - $1) WHERE co_estacion = $2';
$result = pg_prepare($dbconn, "upd91_query", $sql);
if (!$result) {
    die('No se puede preparar la Actualización...');
}
$sql = 'UPDATE estacion SET nu_lts_95 = (nu_lts_95 - $1) WHERE co_estacion = $2';
$result = pg_prepare($dbconn, "upd95_query", $sql);
if (!$result) {
    die('No se puede preparar la Actualización...');
}
$sql = 'UPDATE estacion SET nu_lts_dsl = (nu_lts_dsl - $1) WHERE co_estacion = $2';
$result = pg_prepare($dbconn, "updds_query", $sql);
if (!$result) {
    die('No se puede preparar la Actualización...');
}
$sql = 'INSERT INTO movimiento_estacion (id_estacion,id_verif_estacion,id_tipo_combustible,id_vehiculo_uso,nu_cant_combustible,in_nac_persona,nu_ced_persona,nu_plc_vehiculo,fe_act_movimiento_estacion,nu_imei_dispositivo,co_ticket) VALUES ($1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11)';
$result = pg_prepare($dbconn, "ins_query", $sql);
if (!$result) {
    die('No se puede preparar la Inserción...');
}
$sql = 'INSERT INTO deshabilitado (co_placa, in_nac_persona, nu_ced_persona, fe_inicio) VALUES ($1,$2,$3,$4)';
$result = pg_prepare($dbconn, "insDes_query", $sql);
if (!$result) {
    die('No se puede preparar la Inserción...');
}
$sql = 'UPDATE ticket_estacion SET in_estado_ticket = 1, fe_fin_ticket = $1 WHERE in_estado_ticket = 0 AND nu_ced_persona = $2 AND in_nac_persona = $3 AND nu_plc_vehiculo = $4';
$result = pg_prepare($dbconn, "updtk_query", $sql);
if (!$result) {
    die('No se puede preparar la Actualización...');
}
$sql = 'SELECT co_ticket FROM ticket_estacion WHERE in_estado_ticket = 1 AND fe_fin_ticket = $1 AND nu_ced_persona = $2 AND in_nac_persona = $3 AND nu_plc_vehiculo = $4';
$result = pg_prepare($dbconn, "seltk_query", $sql);
if (!$result) {
    die('No se puede preparar la Consulta...');
}
$sql = 'DELETE FROM ticket_estacion WHERE nu_ced_persona = $1 AND nu_plc_vehiculo = $2';
$result = pg_prepare($dbconn, "deltk_query", $sql);
if (!$result) {
    die('No se puede preparar la Eliminación...');
}
$sql = 'UPDATE estacion_pico SET in_estado=1, co_ticket = $1, nu_lts_estacion_pico = $2, fe_act_estacion_pico = $3 WHERE id_estacion_pico = $4';
$result = pg_prepare($dbconn, "updpi_query", $sql);
if (!$result) {
    die('No se puede preparar la Actualización del Pico...');
}

$callback = isset($_GET['callback']) ? preg_replace('/[^a-z0-9$_]/si', '', $_GET['callback']) : false;
header('Content-Type: ' . ($callback ? 'application/javascript' : 'application/json') . ';charset=UTF-8');

$usr = base64_decode($usr);
$cod = base64_decode($cod);
$ide = base64_decode($ide);
$tco = base64_decode($tco);
$lts = base64_decode($lts);
$uso = base64_decode($uso);
$ced = base64_decode($ced);
$nac = base64_decode($nac);
$plc = strtoupper(base64_decode($plc));
$fna = base64_decode($fna);
$ime = base64_decode($ime);
$hoy = date("Y-m-d H:i:s");

if (isset($pic)) {
    $pic = base64_decode($pic);
}else{
    $pic = 0;
}
$nom = $ide.$ced.$plc.date("YmdHis");
$cotk = md5($nom);

$sql = 'SELECT * FROM persona WHERE UPPER(in_nac_persona) = UPPER(\''.$nac.'\') AND nu_ced_persona = \''.$ced.'\'';
$regs = dbManager::evalSQL($sql);
if (count($regs) == 0) {
    $linea = array();
    $linea[] = base64_encode(0);
    $linea[] = base64_encode('Persona no registrada...');
    $linea[] = base64_encode(1);
    $data[] = $linea;
    echo json_encode($data);
    exit();
}elseif (count($regs) > 1){
    $linea = array();
    $linea[] = base64_encode(0);
    $linea[] = base64_encode('Existe un Error con la información suministrada (Doble Registro)...');
    $linea[] = base64_encode(2);
    $data[] = $linea;
    echo json_encode($data);
    exit();
}/*else{
    foreach ($regs as $key => $reg) {
        if (strtotime($fna) != strtotime($reg['fe_nac_persona'])) {
            $linea = array();
            $linea[] = base64_encode(0);
            $linea[] = base64_encode('Información suministrada no concuerda...');
            $linea[] = base64_encode(3);
            $data[] = $linea;
            echo json_encode($data);
            exit();
        }
    }
}*/

if (!isset($cst)) {
    $sql = 'SELECT * FROM ticket_estacion WHERE co_estacion = \''.$cod.'\' AND UPPER(nu_ced_persona) = UPPER(\''.$ced.'\') AND UPPER(in_nac_persona) = UPPER(\''.$nac.'\') AND UPPER(nu_plc_vehiculo) = UPPER(\''.$plc.'\')';
    $result = pg_query($dbconn, $sql);
    $rows = pg_num_rows($result);
    $ltstck = 0;
    if ($rows > 0) {
        $row = pg_fetch_assoc($result);
        $lts = $row['nu_cant_ticket'];
        $uso = $row['id_vehiculo_uso'];
        $qr = 'temp/qr'.$row['co_ticket'].'.png';
        unlink($qr);
    }
}
    
/*
if ($uso == 2) { //USO PARTICULAR NO OFICIAL
    $sql = 'SELECT * FROM deshabilitado WHERE UPPER(co_placa) = UPPER(\''.$plc.'\') OR ((UPPER(in_nac_persona) = UPPER(\''.$nac.'\') AND nu_ced_persona = \''.$ced.'\'))';
    $regs = dbManager::evalSQL($sql);
    foreach ($regs as $key => $reg) {
        $linea = array();
        $linea[] = base64_encode(0);
        $linea[] = base64_encode('Deshabilitado temporalmente para realizar carga de combustible.');
        $linea[] = base64_encode(4);
        $data[] = $linea;
        echo json_encode($data);
        exit();
    }
}*/
/*
if ($lts <= 0) {
    $lts = 0;
}*/

$act = array();
$act[] = $lts;
$act[] = $cod;

$data = array();

$cantact = 0;
$cantnva = 0;

//INSERTA EN MOVIMIENTO ESTACION
$result = pg_execute($dbconn, "ins_query", array($ide,$usr,$tco,$uso,$lts,$nac,$ced,$plc,$hoy,$ime,$cotk));
if (!$result){
    $linea = array();
    $linea[] = base64_encode(0);
    $linea[] = base64_encode(pg_last_error($dbconn));
    $data[] = $linea;
    echo json_encode($data);
    exit();
}

//ACTUALIZA PARA SOLICITAR LA ACTIVACIÓN DEL PICO
$result = pg_execute($dbconn, "updpi_query", array($cotk,$lts,$hoy,$pic));
if (!$result){
    $linea = array();
    $linea[] = base64_encode(0);
    $linea[] = base64_encode($cotk.' : '.$pic);
    $data[] = $linea;
    echo json_encode($data);
    exit();
}
/*
if ($uso == 2) {
    $result = pg_execute($dbconn, "insDes_query", array($plc,$nac,$ced,$hoy));
    if (!$result){
        $linea = array();
        $linea[] = base64_encode(0);
        $linea[] = base64_encode(pg_last_error($dbconn));
        $data[] = $linea;
        echo json_encode($data);
        exit();
    }

    $result = pg_execute($dbconn, "insDes_query", array($plc,$hoy));
    if (!$result){
        $linea = array();
        $linea[] = base64_encode(0);
        $linea[] = base64_encode(pg_last_error($dbconn));
        $data[] = $linea;
        echo json_encode($data);
        exit();
    }
}*/

//ACTUALIZA EL CONSUMO EN LA ESTACIÓN -- DEBE SER CAMBIADO A SPICO.PHP
/*
if ($tco == 1) { //91
    $result = pg_execute($dbconn, "upd91_query", $act);
}elseif($tco == 2) { //95
    $result = pg_execute($dbconn, "upd95_query", $act);
}elseif($tco == 3) { //Diesel
    $result = pg_execute($dbconn, "updds_query", $act);
}*/

//BORRA EL TICKET (SI EXISTE)
$result = pg_execute($dbconn, "deltk_query", array($ced,$plc));

if (!$result){
    $linea = array();
    $linea[] = base64_encode(0);
    $linea[] = base64_encode(pg_last_error($dbconn));
    $data[] = $linea;
    echo json_encode($data);
    exit();
}

if (!$result) {
    $linea = array();
    $linea[] = base64_encode(0);
    $linea[] = base64_encode(0);
    $data[] = $linea;
}else{
    $linea = array();
    $linea[] = base64_encode(1);
    $linea[] = base64_encode(1);
    $data[] = $linea;
}
echo json_encode($data);
?>