<?php
if ( ! session_id() ) @ session_start();

header("Access-Control-Allow-Origin: *");

include_once('../home.php');
require_once('../assets/dbManager.php');
require_once('qr/qrlib.php');

@define('SCH','public');

dbManager::setQueryLogging(false);
dbManager::configFile('../assets/dbconfig.php');
dbManager::path2Locator(PER);

$PNG_TEMP_DIR = dirname(__FILE__).DIRECTORY_SEPARATOR.'temp'.DIRECTORY_SEPARATOR;


header('Access-Control-Allow-Origin: *');

$dts = isset($_GET) ? $_GET : '0';

$data = getData($dts);

$callback = isset($_GET['callback']) ? preg_replace('/[^a-z0-9$_]/si', '', $_GET['callback']) : false;
header('Content-Type: ' . ($callback ? 'application/javascript' : 'application/json') . ';charset=UTF-8');

echo ($callback ? $callback . '(' : '') . $data . ($callback ? ')' : '');

function getData($dts){

    $PNG_WEB_DIR = 'temp/';

    $errorCorrectionLevel = 'L';

    $matrixPointSize = 10;

	$conn_string = "host=".IPS." port=".DBPORT." dbname=".DBN." user=".DBUSER." password=".DBPASS."";
    $dbconn = pg_connect($conn_string);

    //ced,nac,plc,tpp,est,tco
    
    extract($dts);

    $ced = base64_decode($ced);
    $nac = base64_decode($nac);
    $plc = strtoupper(base64_decode($plc));
    $tpp = base64_decode($tpp);
    $est = base64_decode($est);
    $tco = base64_decode($tco);
    $ime = base64_decode($ime);
    $hoy = date("Y-m-d H:i:s");
    
    if (isset($lts)){
        $lts = base64_decode($lts);
    }else{
        $lts = 0;
    }

    $nom = $est.$ced.$plc.date("YmdHis");
    $cotck = md5($nom);

    $filename = $PNG_WEB_DIR.'qr'.$cotck.'.png';
    QRcode::png($cotck, $filename, $errorCorrectionLevel, $matrixPointSize, 2);    

    $hoy = date("Y-m-d H:i:s");

    $sql = 'INSERT INTO ticket_estacion (co_estacion,nu_ced_persona,in_nac_persona,nu_plc_vehiculo,co_vehiculo_tipo,in_tipo_combustible,fe_crea_ticket,co_ticket,in_estado_ticket,in_semaforo,nu_imei_dispositivo,nu_cant_ticket) VALUES ($1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12)';
    $result = pg_prepare($dbconn, "ins_query", $sql);
    if (!$result) {
        die('No se puede preparar la Inserción...');
    }

    $colp = 0;
    $result = pg_execute($dbconn, "sel_query", array($est,$ced,$nac));
    $rows = pg_num_rows($result);
    if ($rows > 0){
        $colp = 3;
    }

    $result = pg_execute($dbconn, "ins_query", array($est,$ced,$nac,$plc,$tpp,$tco,$hoy,$cotck,0,$colp,$ime,$lts));
    if (!$result){
        $linea = array();
        $linea[] = base64_encode(0);
        $linea[] = base64_encode(pg_last_error($dbconn));
        $data[] = $linea;
        echo json_encode($data);
        exit();
    }
    $urlimg = $PNG_WEB_DIR.'qr'.$cotck.'.png';
    $linea = array();
    $linea[] = base64_encode(1);
    $linea[] = base64_encode($cotck);
    $linea[] = base64_encode(0);
    $linea[] = base64_encode($colp);
    $data[] = $linea;

	return json_encode($data);
}

?>